function [ packages_bits, added_zeros_last_package ] = ...
    generate_packages_from_bitstream(data_bits, ...
    training_bits, nr_databits_in_package,guard_bits)
%Gets bitstream and generates packages with training sequences
%   Detailed explanation goes here

% How many packages we will need to make
nr_packages = ceil(length(data_bits) / nr_databits_in_package);

% How long is one package
training_length = length(training_bits);
package_length = training_length + nr_databits_in_package;

% one package in one row
packages_bits = zeros(nr_packages, package_length);


% generate packages (except for last one)
for package_index=1:nr_packages-1
    
    % Training seq in the beginning of each package
    packages_bits(package_index, 1:training_length) = training_bits;
    
    % Followed by the data bits
    packages_bits(package_index, training_length+1:end) = ...
        data_bits((package_index-1)*nr_databits_in_package+1:...
        package_index*nr_databits_in_package);
end

% generate last package by zero padding
bits_last_package = data_bits((nr_packages-1)*nr_databits_in_package+1:end);

[zp_bits_last_package,added_zeros_last_package] = ...
    zero_padding(bits_last_package,nr_databits_in_package);

packages_bits(nr_packages,1:training_length) = training_bits;
packages_bits(nr_packages,training_length+1:end) = zp_bits_last_package';

% here we are adding two packages of guard bits, one before and one at the
% end

packages_bits = [packages_bits; guard_bits;guard_bits];

end

